/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.internal.tracking;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import org.sonarlint.eclipse.core.internal.tracking.Input;
import org.sonarlint.eclipse.core.internal.tracking.Trackable;

public class Tracking<RAW extends Trackable, BASE extends Trackable> {
    private final IdentityHashMap<RAW, BASE> rawToBase = new IdentityHashMap();
    private final IdentityHashMap<BASE, RAW> baseToRaw = new IdentityHashMap();
    private final Collection<RAW> raws;
    private final Collection<BASE> bases;

    public Tracking(Input<RAW> rawInput, Input<BASE> baseInput) {
        this.raws = rawInput.getIssues();
        this.bases = baseInput.getIssues();
    }

    public Iterable<RAW> getUnmatchedRaws() {
        ArrayList<Trackable> result = new ArrayList<Trackable>();
        for (Trackable r : this.raws) {
            if (this.rawToBase.containsKey(r)) continue;
            result.add(r);
        }
        return result;
    }

    public Map<RAW, BASE> getMatchedRaws() {
        return this.rawToBase;
    }

    public BASE baseFor(RAW raw) {
        return (BASE)((Trackable)this.rawToBase.get(raw));
    }

    public Iterable<BASE> getUnmatchedBases() {
        ArrayList<Trackable> result = new ArrayList<Trackable>();
        for (Trackable b : this.bases) {
            if (this.baseToRaw.containsKey(b)) continue;
            result.add(b);
        }
        return result;
    }

    boolean containsUnmatchedBase(BASE base) {
        return !this.baseToRaw.containsKey(base);
    }

    void match(RAW raw, BASE base) {
        this.rawToBase.put(raw, base);
        this.baseToRaw.put(base, raw);
    }

    boolean isComplete() {
        return this.rawToBase.size() == this.raws.size();
    }
}

